/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.ui.i18n;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import technology.rocketjump.undermount.ui.i18n.I18nWord;

public class I18nLanguageDictionary {
    private final Map<String, I18nWord> dictionary = new ConcurrentHashMap<String, I18nWord>();
    private final String label;
    private final String labelEn;
    private final String iconName;

    public I18nLanguageDictionary(String label, String labelEn, String iconName) {
        this.label = label;
        this.labelEn = labelEn;
        this.iconName = iconName;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLabelEn() {
        return this.labelEn;
    }

    public String getIconName() {
        return this.iconName;
    }

    public I18nWord getWord(String key) {
        return this.dictionary.computeIfAbsent(key, k -> new I18nWord(key));
    }
}

